// buffers.h


typedef struct{
  int size;
  int start_offset;
  int stop_offset;
  int mask;
  unsigned char *data;
} ring_buffer;

ring_buffer *create_ring_buffer(int size);
int destroy_ring_buffer(ring_buffer *buffer);

// Ring buffer stuff
char putbyte(ring_buffer *buffer, unsigned char byte);
char getbyte(ring_buffer *buffer, unsigned char *byte);

char buf_read(ring_buffer *buffer, unsigned char *data, int numbytes);
char buf_write(ring_buffer *buffer, unsigned char *data, int numbytes);


char peekbyte(ring_buffer *buffer, unsigned char *byte, int offset);
char search_buffer(ring_buffer *buffer, unsigned char *lookfor, int lookfor_length, int start_offset, int *found_offset);
int bytes_in_buffer(ring_buffer *buffer);
int free_cont_space(ring_buffer *buffer);
int find_char(ring_buffer *buffer, int search_search_offset, unsigned char lookfor);
char remove_garbage(ring_buffer *buffer, int numbytes);


