void beacon_decode(char *data, int data_len);
#define PACKED __attribute__((__packed__))

/*!\struct eps_beacon_data_s
 * \brief Housekeeping data to be logged.
 */
#pragma pack(1)
typedef struct eps_beacon_data_s // size = 40
{
    unsigned short I_BAT;
    unsigned short V_SA;
    unsigned short BAT1_T;
    unsigned short BAT2_T;
    unsigned short V_BAT;
    unsigned short I_PCU;
    unsigned short T_PRU;
    unsigned short V_MEAS_5;
    unsigned short V_MEAS_3;
    unsigned short T_BAT_Threshold;
    unsigned short V_BAT_Threshold_shutdown;
    unsigned short V_BAT_Threshold_1;
    unsigned short V_BAT_Threshold_2;
    unsigned short V_BAT_Threshold_3;
    unsigned short V_BAT_Threshold_4;
    unsigned char  PDUState;
    unsigned char  TEMP_Disable;
    unsigned short V_BAT_Warn_1;
    unsigned short V_BAT_Warn_2;
    unsigned short V_BAT_Warn_3;
    unsigned short V_BAT_Warn_4;
} eps_beacon_data_t;
#pragma pack()
//} __attribute__((__packed__)) eps_beacon_data_t;


/*!\struct com_beacon_data_s
 * \brief Housekeeping data to be logged.
 */
#pragma pack(1)
typedef struct // size = 11
{
   unsigned char  last_rssi;        // RSSI of last packet, 1B
   unsigned short avg_rssi;         // RSSI avg. of last 16 packets, 2B
   unsigned short nr_rx_packets;    // Number of packets received, 2B, # of packets
   unsigned short nr_rx_ok_packets; // Number of succesfully received packets
   unsigned short nr_tx_packets;    // COM temperature, 2B, Degrees/C
   unsigned char  last_hferr;	      //COM frequency error voltage on last packet uplink, 1B
   unsigned char  last_temp;        //COM temperature for the last packet uplink, 1B
} com_beacon_data_t;
#pragma pack()


/*!\struct adcs_beacon_data_s
 * \brief Housekeeping data to be logged.
 */
#pragma pack(1)
typedef struct // size = 22
{
   unsigned char mode;
   unsigned char gyro[6];
   unsigned char temp[6];
   unsigned char mag[3];
   unsigned char bdot[3];
   char act[3];
} adcs_beacon_data_t;
#pragma pack()


/*!\struct pl_beacon_data_s
 * \brief Housekeeping data to be logged.
 */
#pragma pack(1)
typedef struct // size = 4
{
	char temp0;
   char temp1;
   char temp2;
   char dummy;
} pl_beacon_data_t;
#pragma pack()


/*!\struct log_beacon_data_s
 * \brief Housekeeping data to be logged.
 */
#pragma pack(1)
typedef struct log_beacon_data_s // size = 2
{
   unsigned short flash_free;
   unsigned char flash_status;
} log_beacon_data_t;
#pragma pack()


/*!\struct cdh_beacon_data_s
 * \brief Housekeeping data to be logged.
 */
#pragma pack(1)
typedef struct cdh_beacon_data_s // size = 20
{
	unsigned char beacon_valid;
	unsigned char sw_ver_id;
	unsigned short boots;
	unsigned int uptime;
	unsigned int cur_time;
	unsigned short free_mem;
   unsigned short largest_mem;
	unsigned short temp0;
	unsigned short temp1;
} cdh_beacon_data_t;
#pragma pack()

